<?php
// Example: Informative HTML email body using variables
$emailBody = "
<html>
<head>
  <style>
    body { font-family: Arial, sans-serif; }
    .container { border: 1px solid #ccc; padding: 20px; border-radius: 10px; background-color: #f9f9f9; }
    .header { background-color: " . getWarningColor($warningCode) . "; color: white; padding: 10px 20px; border-radius: 10px 10px 0 0; }
    .section { margin-bottom: 15px; }
    .label { font-weight: bold; color: #333; }
    ul { padding-left: 20px; }
  </style>
</head>
<body>
  <div class='container'>
    <div class='header'>
      <h2>⚠️ Weather Warning: " . ucfirst($warningCode) . " Level</h2>
    </div>
    <div class='section'>
      <p><span class='label'>Issued At:</span> " . date("Y-m-d H:i:s") . "</p>
      <p><span class='label'>Validity (hrs):</span> $validity</p>
      <p><span class='label'>Expected Time of Occurrence:</span> $expectedTime</p>
    </div>
    <div class='section'>
      <p><span class='label'>Likelihood:</span> $likelihood</p>
      <p><span class='label'>Affect Continuity:</span> $affectContinue</p>
      <p><span class='label'>Distribution:</span> $distribution</p>
      <p><span class='label'>Activity Duration (hrs):</span> $activityTime</p>
    </div>
    <div class='section'>
      <p><span class='label'>Affected Districts:</span></p>
      <ul>";
foreach (json_decode($districts) as $district) {
  $emailBody .= "<li>$district</li>";
}
$emailBody .= "</ul>
    </div>
    <div class='section'>
      <p><span class='label'>Advisories:</span></p>
      <ul>";
foreach (json_decode($weatherAdvice) as $advice) {
  $emailBody .= "<li>$advice</li>";
}
$emailBody .= "</ul>
    </div>
    <div class='section'>
      <p><span class='label'>Impacts:</span></p>
      <ul>";
foreach (json_decode($weatherImpact) as $impact) {
  $emailBody .= "<li>$impact</li>";
}
$emailBody .= "</ul>
    </div>
    <div class='section'>
      <p><span class='label'>Warning Message:</span> $warning_message</p>
    </div>
  </div>
</body>
</html>
";

// Helper function to get color for warning level
function getWarningColor($code) {
  switch (strtolower($code)) {
    case "red": return "#e53935";
    case "orange": return "#fb8c00";
    case "yellow": return "#fdd835";
    case "green": return "#43a047";
    default: return "#607d8b";
  }
}
?>
