<?php $__env->startSection('title','Multi User Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<nav class="navbar bg-light shadow">
        <div class="container-fluid">
        <span class="navbar-brand mb-0 h1">Dashboard</span>
        <div>
            <div>
                <?php echo $__env->make('multistationuser.button', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>
        </div>
    </nav>

<div class="container mt-5 mb-5">
  <?php if(session('success')): ?>
    <div class="alert alert-success">
        <?php echo e(session('success')); ?>

    </div>
  <?php endif; ?>
  <div class="container mb-3 d-flex justify-content-between">
    <!--Filter-->
    <div class="flex-grow-1">
      <form action="multistationuser" method="get">
      <?php echo csrf_field(); ?>
        <div class="d-flex flex-wrap gap-3 p-4">
          <div class="d-flex flex-column">
            <label for="filter_date" class="form-label fw-semibold">Filter By Date</label>
            <input type="date" id="filter_date" name="filter_date" class="form-control rounded-pill" value="<?php echo e($date); ?>" required>
          </div>
          <div class="align-self-end">
            <button type="submit" class="btn btn-primary rounded-pill">Apply</button>
          </div>
        </div>
      </form>
    </div>
</div>
    <!--Table-->
   
   <div class="p-4 border border-secondary-subtle rounded-4 shadow" style="width:100%;">
    <div class="d-flex justify-content-between mb-4 mt-2">  
      <h3 class="fw-medium fs-3 text-secondary-emphasis">Rainfall Data</h3>
      <a href="<?php echo e(route('multiuser.generatefile', ['filter_date' => $date])); ?>" class="btn btn-secondary rounded-pill align-self-center">
      Download CSV</a>
    </div>  
    <div class="table-responsive">
      <table class="table table-striped table-bordered shadow table-hover text-center">
        <thead>
          <tr>
               
            <td style="background-color:#00538C;color:white;">DATE</td>
            <td style="background-color:#00538C;color:white;">STATION ID</td>
            <td style="background-color:#00538C;color:white;">STATION NAME</td>
            <td style="background-color:#00538C;color:white;">LATITUDE</td>
            <td style="background-color:#00538C;color:white;">LONGITUDE</td>
            <td style="background-color:#00538C;color:white;">RAINFALL (mm)</td>       
          </tr>
        </thead>
        <tbody>
         <?php $__currentLoopData = $stations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $station): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <?php
            $observation = $observations[$station->id] ?? null;
          ?>
          <tr>
            <td><?php echo e($date); ?></td>
            <td><?php echo e($station->id); ?></td>
            <td><?php echo e($station->station_name); ?></td>
            <td><?php echo e($station->latitude); ?></td>
            <td><?php echo e($station->longitude); ?></td> 
            <td>
              <form action="<?php echo e($observation ? route('multistationuser.updateRainfall',$observation->id) : route('multistationuser.addRainfall')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <?php if($observation): ?>
                <input type="hidden" name="_method" value="patch">
                <?php endif; ?>

                <input type="hidden" name="station_id" value="<?php echo e($station->id); ?>">
                <input type="hidden" name="observation_date" value="<?php echo e($date); ?>">

                <div class="d-flex flex-wrap gap-3 p-4v">
                  <div>
                    <input type="number" step="any" 
                      class="form-control <?php echo e(old('station_id') == $station->id && $errors->has('rainfall') ? 'is-invalid' : ''); ?>" 
                      name="rainfall" id="rainfall" placeholder="Rainfall" 
                      value="<?php echo e(old('station_id') == $station->id ? old('rainfall') : ($observation->rainfall ?? '')); ?>"  
                      required>
                    <?php if(old('station_id') == $station->id): ?>
                      <?php $__errorArgs = ['rainfall'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    <?php endif; ?>
                  </div>
                  <div>
                    <button type="submit" class="btn btn-outline-success">Save</button>
                  </div>
                </div>
              </form>
            </td>
          </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\RMC_project\resources\views/multistationuser/dashboard.blade.php ENDPATH**/ ?>