<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Login Page</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600" rel="stylesheet" />

    <!-- Styles / Scripts -->
    <?php if(file_exists(public_path('build/manifest.json')) || file_exists(public_path('hot'))): ?>
        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <?php endif; ?>

    <style>
        body {
            background-color: #005baa;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            color: #fff;
            text-align: center;
            padding: 1.5rem;
        }
        .logo {
            width: 180px;
            margin-bottom: 1.5rem;
        }
        header {
            position: absolute;
            top: 1.5rem;
            right: 1.5rem;
        }
        .btn-style {
            display: inline-block;
            padding: 0.5rem 1.25rem;
            background-color: white;
            color: #005baa;
            border: 2px solid #005baa;
            border-radius: 0.375rem;
            font-size: 0.9rem;
            font-weight: 500;
            text-decoration: none;
            transition: all 0.3s ease;
        }
        .btn-style:hover {
            background-color: #005baa;
            color: white;
        }
        form button.btn-style {
            cursor: pointer;
            background-color: white;
        }
        form button.btn-style:hover {
            background-color: #005baa;
            color: white;
        }
    </style>
</head>
<body>

    <!-- Login / Register / Dashboard Links -->
    <header>
        <?php if(Route::has('login')): ?>
            <nav class="flex items-center justify-end gap-3">
                <?php if(auth()->guard()->check()): ?>
              <a href="<?php echo e(url('/dashboard')); ?>" class="btn-style">Dashboard</a> 
                <?php else: ?>
           <!--         <a href="<?php echo e(route('login')); ?>" class="btn-style">Log in</a> -->
                    <?php if(Route::has('register')): ?>
                <!--        <a href="<?php echo e(route('register')); ?>" class="btn-style">Register</a> -->
                    <?php endif; ?>
                <?php endif; ?>
            </nav>
        <?php endif; ?>
    </header>

    <!-- Centered Content -->
     
    <main class="text-center">
    <img src="<?php echo e(asset('images/logo.png')); ?>" alt="App logo" class="logo mb-4" />

    <?php if(Auth::check()): ?>
        <p class="mb-3">Logged in as: <?php echo e(Auth::user()->name); ?></p>
    <?php endif; ?>

    <div class="d-flex justify-content-center gap-3">
        <?php if(auth()->guard()->check()): ?>
            <form method="POST" action="<?php echo e(route('logout')); ?>">
                <?php echo csrf_field(); ?>
                <button type="submit" class="btn-style">
                    <?php echo e(__('Log Out')); ?>

                </button>
            </form>
        <?php else: ?>
            <a href="<?php echo e(route('login')); ?>" class="btn-style">
                <?php echo e(__('Log in')); ?>

            </a>
        <?php endif; ?>
    </div>
</main>

<div class="m-3 bg-secondary text-white text-center py-3">
  <h1 style="font-size: 25px;">Automatic Rainfall Data Submission System</h1>
</div>

<footer class="bg-secondary text-white text-center">
    Regional Meteorological Centre Kolkata
</footer> 

</body>
</html>
<?php /**PATH D:\xampp\htdocs\RMC_project\resources\views/welcome.blade.php ENDPATH**/ ?>