<?php $__env->startSection('title','User'); ?>
<?php $__env->startSection('content'); ?>
<?php use Illuminate\Support\Str; ?>

<!--Nav Bar-->
<nav class="navbar bg-light shadow">
  <div class="container-fluid">
    <div class="btn-group" role="group">
      <a href="admin" class="btn btn-outline-primary">Home</a>
      <a href="stationView" class="btn btn-outline-primary">View Stations</a>
      <a href="adminInput" class="btn btn-outline-success">Add User</a>
    </div>
  </div>
</nav>

<!--User Table-->
<div class="container mt-5 mb-5">
  <?php if(session('success')): ?>
    <div class="alert alert-success">
        <?php echo e(session('success')); ?>

    </div>
  <?php endif; ?>
  <div  class="p-1 mb-2">
      <form class="d-flex" role="search" action="users" method="get">
      <input class="form-control me-2 rounded-pill" type="search" name="search" placeholder="Search by...  Name or Role or Email" aria-label="Search" value="<?php echo e(@$search); ?>"/>
        <button class="btn btn-outline-success me-2 rounded-pill" type="submit">Search</button>
        <a href="users" class="btn btn-outline-secondary rounded-pill">Clear</a>
      </form>
    </div>

    <div class="mt-5 p-4 border border-secondary-subtle rounded-4 shadow" style="width:100%;">
    <h3 class="fw-medium mb-4 mt-2 fs-2 text-secondary-emphasis">User Records</h3>
    <div class="table-responsive">
    <table class="table table-striped table-bordered shadow table-hover text-center">
    <thead>
        <tr>
            <td style="background-color:#00538C;color:white;">ID</td>
            <td style="background-color:#00538C;color:white;">NAME</td>
            <td style="background-color:#00538C;color:white;">ROLE</td>
            <td style="background-color:#00538C;color:white;">OBSERVER ID</td>
            <td style="background-color:#00538C;color:white;">STATION ID</td>
            <td style="background-color:#00538C;color:white;">MOBILE</td>
            <td style="background-color:#00538C;color:white;">EMAIL</td>
            <td style="background-color:#00538C;color:white;">EDIT</td>
            <td style="background-color:#00538C;color:white;">DEACTIVATE</td>
        </tr>
    </thead>
    <tbody>
    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr <?php if(Str::startsWith($user->email,'deactivated.')): ?> class="table-danger table-borderd" <?php endif; ?>">
            <td><?php echo e($user->id); ?></td>
            <td><?php echo e($user->name); ?></td>
            <td><?php echo e($user->role); ?></td>
            <td><?php echo e($user->observer_id); ?></td>
            <td>
              <?php if($user->role == 'multistationuser'): ?> 
                <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="collapse" data-bs-target="#stations-<?php echo e($user->id); ?>">
                    View Stations (<?php echo e($user->stations->count()); ?>)
                </button>
                <div id="stations-<?php echo e($user->id); ?>" class="collapse mt-2">
                    <ul class="list-group list-group-flush">
                        <?php $__currentLoopData = $user->stations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $station): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="list-group-item p-1"><?php echo e($station->id); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
              <?php else: ?>
                <?php echo e($user->station_id); ?>

              <?php endif; ?>             
            </td>
            <td><?php echo e($user->phone); ?></td>
            <td><?php echo e($user->email); ?></td>
            <td><a href="<?php echo e(route('admin.edit.update',$user->id)); ?>" class="btn btn-outline-primary">EDIT</a></td>
            <td>
            <form action="<?php echo e(route('admin.users.deactivate', $user->id)); ?>" method="post" style="display:inline;" onsubmit="return confirm('Do you want to deactivate this employee?')">
              <?php echo csrf_field(); ?> 
              <?php echo method_field('DELETE'); ?>
              <button type="submit" class="btn btn-outline-danger">DEACTIVATE</button>
            </form>
            </td>
          </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
    </table>
    </div>
    </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\RMC_project\resources\views/admin/users.blade.php ENDPATH**/ ?>