<?php $__env->startSection('title','observations'); ?>
<?php $__env->startSection('content'); ?>
<nav class="navbar bg-light shadow">
  <div class="container-fluid">
  <?php if(Auth::user()->role === 'meteorologist'): ?>
    <div class="btn-group" role="group">
      <a href="meteorologist" class="btn btn-outline-primary">Home</a>
      <a href="meteorologistfilter1" class="btn btn-outline-success">Upload Records</a>
    </div>
    
  <?php elseif(Auth::user()->role === 'admin'): ?>
      <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-outline-primary">Home</a>
  <?php endif; ?>
  </div>
</nav>

<div class="container mt-5 mb-5">
<div class="container p-4 border rounded-4 mb-5">
<form method="get" action="meteorologistobservation">
    <div class="row g-3 justify-content-center align-items-end">
      <div class="col-md-4">
      <label for="station_id" class="form-label fw-semibold">Select Station</label>
      <select name="station_id"  class="form-select">
        <option value="" default>All stations</option>
        <?php $__currentLoopData = $allstations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $station): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
       <option value="<?php echo e($station->id); ?>" <?php echo e(request('station_id') == $station->id ? 'selected' : ''); ?>>
        <?php echo e($station->station_name); ?>

      </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </select>

    </div>
    <div class="col-md-4">
      <label for="range_type" class="form-label fw-semibold">Date Range</label>
      <select name="range_type" class="form-select">
        <option value="" default>None</option>
        <option value="daily" <?php echo e(request('range_type')== 'daily' ? 'selected' : ''); ?>>Daily</option>
        <option value="weekly"  <?php echo e(request('range_type')== 'weekly' ? 'selected' : ''); ?>>Weekly</option>
        <option value="monthly"  <?php echo e(request('range_type')== 'monthly' ? 'selected' : ''); ?>>Monthly</option>
      </select>
    </div>

<div class="col-md-4">
      <label for="start_date" class="form-label fw-semibold">Start Date</label>
      <input type="date" name="start_date" value="<?php echo e(request('start_date')); ?>" class="form-control"/>
</div>
<div class="col-md-4">
      <label for="end_date" class="form-label fw-semibold">End Date</label>
      <input type="date" name="end_date" value="<?php echo e(request('end_date')); ?>" class="form-control"/>
</div>
<div class="col-md-2 d-grid">
      <button type="submit" class="btn btn-primary rounded-pill">Apply</button>
    </div>
  </div>
</form>
</div>

<!--Table-->
  <div class="p-4 border border-secondary-subtle rounded-4 shadow" style="width:100%;">
  <div class="d-flex justify-content-between mb-4 mt-2">  
    <h3 class="fw-medium fs-3 text-secondary-emphasis">Final Report</h3>
    <a href="<?php echo e(route('meteo.generateReport', ['start_date' => request('start_date') ,'end_date' => request('end_date'),'station_id' => request('station_id'),'range_type' =>request('range_type')])); ?>" class="btn btn-secondary rounded-pill align-self-center">
    Download CSV</a>
  </div>

    <div class="table-responsive">
    <table class="table table-striped table-bordered shadow table-hover text-center">
    <thead>
        <tr>
            <td style="background-color:#00538C;color:white;">STATION ID</td>
            <td style="background-color:#00538C;color:white;">DATE</td>
            <td style="background-color:#00538C;color:white;">DATE OF OBSERVATION</td>
            <td style="background-color:#00538C;color:white;">STATION NAME</td>
            <td style="background-color:#00538C;color:white;">LATITUDE</td>
            <td style="background-color:#00538C;color:white;">LONGITUDE</td>
            <td style="background-color:#00538C;color:white;">RAINFALL</td>
            
        </tr>
    </thead>
     <tbody>
    <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $obdata): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td><?php echo e($obdata->station_id); ?></td>
            <td><?php echo e($obdata->date); ?></td>
            <td><?php echo e($obdata->observation_date); ?></td>
            <td><?php echo e($obdata->station->station_name ?? 'N/A'); ?></td>
            <td><?php echo e($obdata->station->latitude ?? 'N/A'); ?></td>
            <td><?php echo e($obdata->station->longitude ?? 'N/A'); ?></td>
            <td><?php echo e($obdata->rainfall); ?></td>
            
          </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>

    </table>
    </div>
</div>
</div>
    <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\RMC_project\resources\views/meteorologist/observation.blade.php ENDPATH**/ ?>